/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.lang.JavaInterruptedException;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.PrologControl;
import com.googlecode.prolog_cafe.lang.PrologException;
import com.googlecode.prolog_cafe.lang.PrologMachineCopy;
import com.googlecode.prolog_cafe.lang.Term;

public class BlockingPrologControl
extends PrologControl
implements Runnable {
    private volatile Thread thread;
    private boolean result;
    private boolean resultReady;

    public BlockingPrologControl() {
    }

    public BlockingPrologControl(PrologMachineCopy prologMachineCopy) {
        super(prologMachineCopy);
    }

    public synchronized boolean execute(String string, String string2, Term ... termArray) {
        return this.execute(this.getPrologClassLoader().predicate(string, string2, termArray));
    }

    public synchronized boolean execute(Predicate predicate) {
        this.setPredicate(predicate);
        this.thread = new Thread(this);
        this.thread.setName("Prolog-" + predicate.toString());
        this.thread.start();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.stop();
        return this.result;
    }

    public synchronized boolean call() {
        this.start();
        return this.next();
    }

    public synchronized boolean redo() {
        this.cont();
        return this.next();
    }

    @Override
    protected synchronized void success() {
        this.resultReady = true;
        this.result = true;
        this.notifyAll();
        while (this.thread != null && this.resultReady) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    protected synchronized void fail() {
        this.resultReady = true;
        this.result = false;
        this.notifyAll();
        while (this.thread != null && this.resultReady) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public boolean isEngineStopped() {
        return this.thread == null;
    }

    public synchronized void join() {
        while (this.thread != null && !this.resultReady) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.stop();
    }

    public synchronized void stop() {
        this.resultReady = false;
        this.thread = null;
        this.notifyAll();
    }

    public synchronized void start() {
        this.resultReady = false;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public synchronized void cont() {
        this.resultReady = false;
        this.notifyAll();
    }

    public synchronized boolean ready() {
        return this.resultReady;
    }

    public synchronized boolean in_success() {
        return this.ready() && this.result;
    }

    public synchronized boolean in_failure() {
        return this.ready() && !this.result;
    }

    public synchronized boolean next() {
        while (this.thread != null && !this.resultReady) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.result) {
            this.stop();
        }
        return this.result;
    }

    @Override
    public void run() {
        try {
            this.executePredicate();
        }
        catch (JavaInterruptedException javaInterruptedException) {
            System.exit(1);
        }
        catch (PrologException prologException) {
            if (this.engine.getPrintStackTrace().equals("on")) {
                this.printStackTrace(prologException);
            } else {
                System.out.println(prologException.toString());
            }
        }
        catch (Exception exception) {
            this.printStackTrace(exception);
        }
        this.stop();
    }
}

