/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.lang.ListTerm;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.PrologControl;
import com.googlecode.prolog_cafe.lang.PrologMachineCopy;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import java.util.ArrayList;
import java.util.List;

public class BufferingPrologControl
extends PrologControl {
    private int resLimit;
    private List resBuffer;
    private boolean resSingle;
    private Term[] resTemplate;

    public BufferingPrologControl() {
    }

    public BufferingPrologControl(PrologMachineCopy prologMachineCopy) {
        super(prologMachineCopy);
    }

    public boolean initialize(String ... stringArray) {
        SymbolTerm symbolTerm = SymbolTerm.intern("true");
        Term term = Prolog.Nil;
        for (int i = stringArray.length - 1; 0 <= i; --i) {
            term = new ListTerm(SymbolTerm.intern(stringArray[i]), term);
        }
        return this.execute("com.googlecode.prolog_cafe.builtin", "initialization", term, symbolTerm);
    }

    public boolean execute(String string, String string2, Term ... termArray) {
        return this.once(string, string2, termArray) != null;
    }

    public Term once(String string, String string2, Term term) {
        this.setPredicate(string, string2, term);
        this.setResultTemplate(term);
        return this.run(1) ? this.resBuffer.get(0) : null;
    }

    public Term[] once(String string, String string2, Term ... termArray) {
        this.setPredicate(string, string2, termArray);
        this.setResultTemplate(termArray);
        return this.run(1) ? this.resBuffer.get(0) : null;
    }

    public List<Term> all(String string, String string2, Term term) {
        this.setPredicate(string, string2, term);
        this.setResultTemplate(term);
        this.run(Integer.MAX_VALUE);
        return this.resBuffer;
    }

    public List<Term[]> all(String string, String string2, Term ... termArray) {
        this.setPredicate(string, string2, termArray);
        this.setResultTemplate(termArray);
        this.run(Integer.MAX_VALUE);
        return this.resBuffer;
    }

    private void setResultTemplate(Term term) {
        this.resTemplate = new Term[]{term};
        this.resSingle = true;
    }

    private void setResultTemplate(Term[] termArray) {
        this.resTemplate = termArray;
        this.resSingle = false;
    }

    private boolean run(int n) {
        this.resLimit = n;
        this.resBuffer = new ArrayList(Math.min(n, 16));
        this.executePredicate();
        return 0 < this.resBuffer.size();
    }

    @Override
    public boolean isEngineStopped() {
        return this.resLimit <= this.resBuffer.size();
    }

    @Override
    protected void success() {
        Term[] termArray = new Term[this.resTemplate.length];
        for (int i = 0; i < this.resTemplate.length; ++i) {
            termArray[i] = this.engine.copy(this.resTemplate[i]);
        }
        this.resBuffer.add(this.resSingle ? termArray[0] : termArray);
    }

    @Override
    protected void fail() {
        this.resLimit = 0;
    }
}

