/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.lang.ChoicePointFrame;
import com.googlecode.prolog_cafe.lang.Trail;

public final class ChoicePointStack {
    private final Trail trail;
    ChoicePointFrame top;
    private int level;

    ChoicePointStack(Trail trail) {
        this.trail = trail;
        this.level = -1;
    }

    void push(ChoicePointFrame choicePointFrame) {
        choicePointFrame.prior = this.top;
        this.top = choicePointFrame;
        ++this.level;
        this.trail.timeStamp = choicePointFrame.timeStamp;
    }

    public void cut(int n) {
        while (this.level > n) {
            this.top = this.top.prior;
            --this.level;
        }
        this.updateTrailTimeStamp();
    }

    void delete() {
        this.top = this.top.prior;
        --this.level;
        this.updateTrailTimeStamp();
    }

    void init() {
        this.top = null;
        this.level = -1;
        this.updateTrailTimeStamp();
    }

    private void updateTrailTimeStamp() {
        this.trail.timeStamp = this.top != null ? this.top.timeStamp : Long.MIN_VALUE;
    }

    public int top() {
        return this.level;
    }

    public int max() {
        return Integer.MAX_VALUE;
    }

    public void show() {
        if (this.top == null) {
            System.out.println("{choice point stack is empty!}");
            return;
        }
        ChoicePointFrame choicePointFrame = this.top;
        while (choicePointFrame != null) {
            System.out.println(choicePointFrame);
            choicePointFrame = choicePointFrame.prior;
        }
    }
}

