/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.lang.ExistenceException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.PredicateEncoder;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.Success;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import java.lang.reflect.Constructor;
import java.util.concurrent.ConcurrentHashMap;

public class PrologClassLoader
extends ClassLoader {
    private final ConcurrentHashMap<Key, CacheEntry> predicateCache = new ConcurrentHashMap();

    public PrologClassLoader() {
    }

    public PrologClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public boolean definedPredicate(String string, String string2, int n) {
        try {
            return this.findPredicate(string, string2, n) instanceof ValidPredicate;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public Predicate predicate(String string, String string2, Term ... termArray) {
        return this.predicate(string, string2, Success.SUCCESS, termArray);
    }

    public Predicate predicate(String string, String string2, Operation operation, Term ... termArray) {
        int n = termArray.length;
        try {
            CacheEntry cacheEntry = this.findPredicate(string, string2, n);
            if (cacheEntry instanceof ValidPredicate) {
                Object[] objectArray = new Object[n + 1];
                for (int i = 0; i < n; ++i) {
                    objectArray[i] = termArray[i];
                }
                objectArray[n] = operation;
                return ((ValidPredicate)cacheEntry).constructor.newInstance(objectArray);
            }
        }
        catch (Exception exception) {
            ExistenceException existenceException = new ExistenceException("procedure", PrologClassLoader.term(string, string2, n), exception.toString());
            existenceException.initCause(exception);
            throw existenceException;
        }
        throw new ExistenceException("procedure", PrologClassLoader.term(string, string2, n), "NOT_FOUND");
    }

    private static StructureTerm term(String string, String string2, int n) {
        return new StructureTerm(":", SymbolTerm.create(string), new StructureTerm("/", SymbolTerm.create(string2), new IntegerTerm(n)));
    }

    private CacheEntry findPredicate(String string, String string2, int n) throws ClassNotFoundException {
        Key key = new Key(string, string2, n);
        CacheEntry cacheEntry = this.predicateCache.get(key);
        if (cacheEntry == null) {
            Constructor<Predicate> constructor;
            Class<?> clazz;
            try {
                clazz = Class.forName(PredicateEncoder.encode(string, string2, n), false, this);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.predicateCache.put(key, NotFound.INSTANCE);
                throw classNotFoundException;
            }
            if (!Predicate.class.isAssignableFrom(clazz)) {
                this.predicateCache.put(key, NotFound.INSTANCE);
                throw new ClassNotFoundException(clazz.getName(), new ClassCastException("Does not extend " + Predicate.class));
            }
            Class[] classArray = new Class[n + 1];
            for (int i = 0; i < n; ++i) {
                classArray[i] = Term.class;
            }
            classArray[n] = Operation.class;
            try {
                constructor = clazz.getDeclaredConstructor(classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.predicateCache.put(key, NotFound.INSTANCE);
                throw new ClassNotFoundException("Wrong constructor on " + clazz.getName(), noSuchMethodException);
            }
            catch (SecurityException securityException) {
                this.predicateCache.put(key, NotFound.INSTANCE);
                throw new ClassNotFoundException("Constructor not visible " + clazz.getName(), securityException);
            }
            constructor.setAccessible(true);
            try {
                Class.forName(clazz.getName(), true, this);
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.predicateCache.put(key, NotFound.INSTANCE);
                throw new ClassNotFoundException("Cannot initialize " + clazz.getName(), classNotFoundException);
            }
            catch (RuntimeException runtimeException) {
                this.predicateCache.put(key, NotFound.INSTANCE);
                throw new ClassNotFoundException("Cannot initialize " + clazz.getName(), runtimeException);
            }
            catch (LinkageError linkageError) {
                this.predicateCache.put(key, NotFound.INSTANCE);
                throw new ClassNotFoundException("Cannot initialize " + clazz.getName(), linkageError);
            }
            cacheEntry = new ValidPredicate(constructor);
            this.predicateCache.put(key, cacheEntry);
        }
        return cacheEntry;
    }

    private static class ValidPredicate
    extends CacheEntry {
        final Constructor<Predicate> constructor;

        ValidPredicate(Constructor<Predicate> constructor) {
            this.constructor = constructor;
        }
    }

    private static class NotFound
    extends CacheEntry {
        static final NotFound INSTANCE = new NotFound();

        private NotFound() {
        }
    }

    private static abstract class CacheEntry {
        private CacheEntry() {
        }
    }

    private static final class Key {
        final String pkg;
        final String functor;
        final int arity;

        Key(String string, String string2, int n) {
            this.pkg = string;
            this.functor = string2;
            this.arity = n;
        }

        public int hashCode() {
            int n = this.pkg.hashCode();
            n = n * 31 + this.functor.hashCode();
            n = n * 31 + this.arity;
            return n;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return this.arity == key.arity && this.pkg.equals(key.pkg) && this.functor.equals(key.functor);
            }
            return false;
        }
    }
}

