/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.lang.HaltException;
import com.googlecode.prolog_cafe.lang.InternalDatabase;
import com.googlecode.prolog_cafe.lang.JavaInterruptedException;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.Predicate;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.PrologClassLoader;
import com.googlecode.prolog_cafe.lang.PrologException;
import com.googlecode.prolog_cafe.lang.PrologMachineCopy;
import com.googlecode.prolog_cafe.lang.Success;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import java.util.Set;

public abstract class PrologControl {
    protected Prolog engine;
    protected Operation code;

    public PrologControl() {
        this.engine = new Prolog(this);
    }

    public PrologControl(PrologMachineCopy prologMachineCopy) {
        this.engine = new Prolog(this, prologMachineCopy);
    }

    public boolean isEnabled(Prolog.Feature feature) {
        return this.engine.features.contains((Object)feature);
    }

    public void setEnabled(Prolog.Feature feature, boolean bl) {
        if (bl) {
            this.engine.features.add(feature);
        } else {
            this.engine.features.remove((Object)feature);
        }
    }

    public void setEnabled(Set<Prolog.Feature> set, boolean bl) {
        if (bl) {
            this.engine.features.addAll(set);
        } else {
            this.engine.features.removeAll(set);
        }
    }

    public int getMaxDatabaseSize() {
        if (this.engine.internalDB != null) {
            return this.engine.internalDB.maxContents;
        }
        return 100000;
    }

    public void setMaxDatabaseSize(int n) {
        if (this.engine.aregs != null) {
            throw new IllegalStateException("Prolog already initialized");
        }
        if (this.engine.internalDB != null) {
            this.engine.internalDB.maxContents = n;
        } else {
            this.engine.internalDB = new InternalDatabase(n);
        }
    }

    public PrologClassLoader getPrologClassLoader() {
        if (this.engine.pcl == null) {
            this.engine.pcl = new PrologClassLoader();
        }
        return this.engine.pcl;
    }

    public void setPrologClassLoader(PrologClassLoader prologClassLoader) {
        if (this.engine.aregs != null) {
            throw new IllegalStateException("Prolog already initialized");
        }
        this.engine.pcl = prologClassLoader;
    }

    public int getMaxArity() {
        return this.engine.getMaxArity();
    }

    public void setMaxArity(int n) {
        if (n < 8) {
            throw new IllegalStateException("invalid arity " + n);
        }
        if (this.engine.aregs != null) {
            throw new IllegalStateException("Prolog already initialized");
        }
        this.engine.maxArity = n;
    }

    public void setPredicate(Predicate predicate) {
        predicate.cont = Success.SUCCESS;
        this.code = predicate;
    }

    public void setPredicate(String string, String string2, Term ... termArray) {
        this.setPredicate(this.getPrologClassLoader().predicate(string, string2, termArray));
    }

    public void setPredicate(Term term) {
        this.setPredicate("com.googlecode.prolog_cafe.builtin", "call", term);
    }

    protected abstract void success();

    protected abstract void fail();

    public abstract boolean isEngineStopped();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executePredicate() throws PrologException, JavaInterruptedException {
        Prolog prolog = this.engine;
        Operation operation = this.code;
        try {
            prolog.init();
            do {
                if (this.isEngineStopped()) {
                    return;
                }
                operation = operation.exec(prolog);
            } while (prolog.halt == 0);
            if (prolog.halt != 1) {
                throw new HaltException(prolog.halt - 1);
            }
        }
        finally {
            this.code = operation;
            SymbolTerm.gc();
        }
    }

    public void printStackTrace(Throwable throwable) {
        throwable.printStackTrace();
    }
}

