/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.lang.BlockingPrologControl;
import com.googlecode.prolog_cafe.lang.HaltException;
import com.googlecode.prolog_cafe.lang.ListTerm;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;
import java.util.StringTokenizer;

public class PrologMain {
    public static final String VERSION = "Prolog Cafe 1.2.5 (mantis)";
    public static final String COPYRIGHT = "Copyright(C) 1997-2009 M.Banbara and N.Tamura";

    public static void main(String[] stringArray) {
        try {
            System.err.println("\nProlog Cafe 1.2.5 (mantis)");
            System.err.println(COPYRIGHT);
            if (stringArray.length != 1) {
                PrologMain.usage();
                System.exit(999);
            }
            Term term = Prolog.Nil;
            term = new ListTerm(SymbolTerm.intern("user"), term);
            term = new ListTerm(SymbolTerm.intern("com.googlecode.prolog_cafe.builtin"), term);
            Term term2 = PrologMain.parseAtomicGoal(stringArray[0]);
            if (term2 == null) {
                PrologMain.usage();
                System.exit(1);
            }
            BlockingPrologControl blockingPrologControl = new BlockingPrologControl();
            blockingPrologControl.setPredicate("com.googlecode.prolog_cafe.builtin", "initialization", term, term2);
            boolean bl = blockingPrologControl.call();
            while (bl) {
                bl = blockingPrologControl.redo();
            }
            System.exit(0);
        }
        catch (HaltException haltException) {
            System.exit(haltException.getStatus());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    protected static Term parseAtomicGoal(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = stringTokenizer.countTokens();
        if (n == 1) {
            Term[] termArray = new Term[]{SymbolTerm.intern("user"), SymbolTerm.create(stringTokenizer.nextToken())};
            return new StructureTerm(SymbolTerm.intern(":", 2), termArray);
        }
        if (n == 2) {
            Term[] termArray = new Term[]{SymbolTerm.create(stringTokenizer.nextToken()), SymbolTerm.create(stringTokenizer.nextToken())};
            return new StructureTerm(SymbolTerm.intern(":", 2), termArray);
        }
        return null;
    }

    protected static void usage() {
        String string = "Usage:\n";
        string = string + "java -cp $PLCAFEDIR/plcafe.jar";
        string = string + " com.googlecode.prolog_cafe.lang.PrologMain package:predicate\n";
        string = string + "java -cp $PLCAFEDIR/plcafe.jar";
        string = string + " com.googlecode.prolog_cafe.lang.PrologMain predicate\n";
        string = string + "    package:        package name\n";
        string = string + "    predicate:      predicate name (only atom)";
        System.out.println(string);
    }
}

