/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.lang.BuiltinException;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.JavaObjectTerm;
import com.googlecode.prolog_cafe.lang.Operation;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Term;

public class SyntaxException
extends BuiltinException {
    public static final SymbolTerm SYNTAX_ERROR = SymbolTerm.intern("syntax_error", 5);
    public String type;
    public Term culprit;
    public String message;

    public SyntaxException(String string, Term term, String string2) {
        this.type = string;
        this.culprit = term;
        this.message = string2;
    }

    public SyntaxException(Operation operation, int n, String string, Term term, String string2) {
        this.goal = operation;
        this.argNo = n;
        this.type = string;
        this.culprit = term;
        this.message = string2;
    }

    @Override
    public Term getMessageTerm() {
        Term[] termArray = new Term[]{new JavaObjectTerm(this.goal), new IntegerTerm(this.argNo), SymbolTerm.create(this.type), this.culprit, SymbolTerm.create(this.message)};
        return new StructureTerm(SYNTAX_ERROR, termArray);
    }

    @Override
    public String toString() {
        String string = "{SYNTAX ERROR: " + this.goal.toString();
        if (this.argNo > 0) {
            string = string + " - arg " + this.argNo;
        }
        string = string + ": expected " + this.type;
        string = string + ", found " + this.culprit.toString();
        string = string + "}";
        return string;
    }
}

