/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.prolog_cafe.lang;

import com.googlecode.prolog_cafe.lang.ClosureTerm;
import com.googlecode.prolog_cafe.lang.DoubleTerm;
import com.googlecode.prolog_cafe.lang.IntegerTerm;
import com.googlecode.prolog_cafe.lang.JavaObjectTerm;
import com.googlecode.prolog_cafe.lang.ListTerm;
import com.googlecode.prolog_cafe.lang.Prolog;
import com.googlecode.prolog_cafe.lang.StructureTerm;
import com.googlecode.prolog_cafe.lang.SymbolTerm;
import com.googlecode.prolog_cafe.lang.Trail;
import com.googlecode.prolog_cafe.lang.VariableTerm;

public abstract class Term
implements Comparable<Term> {
    public static final int EQUAL = 0;
    public static final int AFTER = 1;
    public static final int BEFORE = -1;

    public abstract boolean unify(Term var1, Trail var2);

    public final boolean isVariable() {
        return this instanceof VariableTerm;
    }

    public final boolean isInteger() {
        return this instanceof IntegerTerm;
    }

    public final boolean isDouble() {
        return this instanceof DoubleTerm;
    }

    public final boolean isNumber() {
        return this instanceof IntegerTerm || this instanceof DoubleTerm;
    }

    public final boolean isSymbol() {
        return this instanceof SymbolTerm;
    }

    public final boolean isNil() {
        return Prolog.Nil.equals(this);
    }

    public final boolean isList() {
        return this instanceof ListTerm;
    }

    public final boolean isStructure() {
        return this instanceof StructureTerm;
    }

    public final boolean isJavaObject() {
        return this instanceof JavaObjectTerm;
    }

    public final boolean isClosure() {
        return this instanceof ClosureTerm;
    }

    public abstract String name();

    public int arity() {
        return 0;
    }

    public Term arg(int n) {
        throw new ArrayIndexOutOfBoundsException(n);
    }

    public boolean convertible(Class clazz) {
        return Term.convertible(this.getClass(), clazz);
    }

    protected Term copy(Prolog prolog) {
        return this;
    }

    public Term dereference() {
        return this;
    }

    public boolean isGround() {
        return true;
    }

    public Object toJava() {
        return this;
    }

    public String toQuotedString() {
        return this.toString();
    }

    protected static boolean convertible(Class clazz, Class<?> clazz2) {
        if (clazz == null) {
            return !clazz2.isPrimitive();
        }
        if (clazz2.isAssignableFrom(clazz)) {
            return true;
        }
        if (clazz2.isPrimitive()) {
            if (clazz.equals(Boolean.class)) {
                return clazz2.equals(Boolean.TYPE);
            }
            if (clazz.equals(Byte.class)) {
                return clazz2.equals(Byte.TYPE) || clazz2.equals(Short.TYPE) || clazz2.equals(Integer.TYPE) || clazz2.equals(Long.TYPE) || clazz2.equals(Float.TYPE) || clazz2.equals(Double.TYPE);
            }
            if (clazz.equals(Short.class)) {
                return clazz2.equals(Short.TYPE) || clazz2.equals(Integer.TYPE) || clazz2.equals(Long.TYPE) || clazz2.equals(Float.TYPE) || clazz2.equals(Double.TYPE);
            }
            if (clazz.equals(Character.class)) {
                return clazz2.equals(Character.TYPE) || clazz2.equals(Integer.TYPE) || clazz2.equals(Long.TYPE) || clazz2.equals(Float.TYPE) || clazz2.equals(Double.TYPE);
            }
            if (clazz.equals(Integer.class)) {
                return clazz2.equals(Integer.TYPE) || clazz2.equals(Long.TYPE) || clazz2.equals(Float.TYPE) || clazz2.equals(Double.TYPE);
            }
            if (clazz.equals(Long.class)) {
                return clazz2.equals(Long.TYPE) || clazz2.equals(Float.TYPE) || clazz2.equals(Double.TYPE);
            }
            if (clazz.equals(Float.class)) {
                return clazz2.equals(Float.TYPE) || clazz2.equals(Double.TYPE);
            }
            if (clazz.equals(Double.class)) {
                return clazz2.equals(Double.TYPE);
            }
        }
        return false;
    }

    public static boolean instanceOfTerm(Object object) {
        return object instanceof VariableTerm || object instanceof IntegerTerm || object instanceof DoubleTerm || object instanceof SymbolTerm || object instanceof ListTerm || object instanceof StructureTerm || object instanceof JavaObjectTerm || object instanceof ClosureTerm;
    }
}

